package p16_pliki;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalTime;

public class Zapis4_Try_Finally {
    public static void main(String[] args) {
        LocalTime now = LocalTime.now();
        System.out.println("Start o " + now);
        // ostatnia cyfra sekundy
        int cyfra = now.getSecond() % 10;
        // Przed Javą 7 oraz gdy klasa nie implementuje interfejsu AutoCloseable
        // można użyć sekcji finally w taki sposób:
        PrintWriter out = null;
        try {
            out = new PrintWriter("out/nowy4.txt");
            out.println("Pierwsza linia");
            out.println("Druga linia");
            out.println("Czas modyfikacji: " + now);
            int wynik = 100 / cyfra;
            out.println("Wynik dzielenia: " + wynik);
            out.println("Ostatnia linia");
        } catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        } finally {
            if (out != null) {
                out.close();
            }
        }
        System.out.println("Koniec");
    }
}
