package p16_pliki;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalTime;

public class Zapis3_Try_With_Resources {
    public static void main(String[] args) {
        LocalTime now = LocalTime.now();
        System.out.println("Start o " + now);
        // ostatnia cyfra sekundy
        int cyfra = now.getSecond() % 10;
        // Od Java 7 mamy konstrukcję "try-with-resources"
        // w momencie wychodzenia z tego bloku (ale także w sposób wyjątkowy) na obiekcie out zostanie wywołane close
        try(PrintWriter out = new PrintWriter("out/nowy3.txt")) {
            out.println("Pierwsza linia");
            out.println("Druga linia");
            out.println("Czas modyfikacji: " + now);
            int wynik = 100 / cyfra;
            out.println("Wynik dzielenia: " + wynik);
            out.println("Ostatnia linia");
        } catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Koniec");
    }
}
