package p14_napisy;

import java.util.ArrayList;
import java.util.List;

public class ParametryString {

	public static void main(String[] args) {
		String a = "Ala";
		
		System.out.println("a1 = " + a);
		m(a);
		System.out.println("a2 = " + a);
		// String is immutable

		// Zmienna final String byłaby niezmienialna w żaden sposób.
		// Ale samo słowo final działa "płytko". Np. tutaj oznacza,
		// że w zmiennej lista do końca programu będzie ten sam obiekt listy,
		// ale wnętrze listy może się zmieniać, bo ArrayList jest mutowalna.
		final List<String> lista = new ArrayList<>();
		lista.add("Ala");
		System.out.println(lista);
		lista.add("Ola");
		lista.add("Ela");
		System.out.println(lista);

		// btw, List.of("Ala", "Ola", "Ela"); jest niemutowalne; operacje add / remove wyrzucaja wyjątki
	}
	
	static void m(String c) {
		System.out.println("c1 = " + c);
		c += " ma kota";
		System.out.println("c2 = " + c);
		// tak naprawdę jest tworzony nowy obiekt String: c = new String("Ala" + " ma kota")
		// a oryginalny obiekt, na który wskazuje zmienna a, nie zmienia się
	}

}
