package p12_kolekcje.zbieranie_danych;

import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class P3_HashSet {
	// Zbiory:
	// - nie zawierają duplikatów (dodanie kolejny raz tej samej wartości nie zmienia już zbioru),
	// - mają prawo zmienić kolejność elementów
	//   → HashSet zmienia kolejność (wg własnych zasad w oparciu o haszkody, na co nie mamy wpływu)
	//   → LinkedHashSet nie zmienia kolejności (zachowuje początkową kolejność, w jakiej elementy były dodawane)
	//   → TreeSet samoczynnie sortuje elementy
	// Podstawową (i wydajną) operacją dla zbioru jest sprawdzenie czy element należy do zbioru.

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		
		Set<String> zbior = new HashSet<>();
		
		while(true) {
			System.out.print("Podaj imię: ");
			// pusty String oznacza koniec
			String imie = scanner.nextLine();
			if(imie.isEmpty()) {
				break;
			}
			zbior.add(imie);
		}
		
		System.out.println(zbior);
		System.out.println();
		
		// Drugi etap: użytkownik podaje imię, a program sprawdza, czy takie imię istnieje - to jest najbardziej podstawowa operacja dla zbiorów.
		// pusty string kończy
		while(true) {
			System.out.print("Podaj imię: ");
			String imie = scanner.nextLine();
			if(imie.isEmpty()) {
				break;
			}
			if(zbior.contains(imie)) {
				System.out.println("TAK");
			} else {
				System.out.println("NIE");
			}
		}
	}

}
