package p12_kolekcje.sortowanie;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class Sortowanie {

	public static void main(String[] args) {
		String[] tablica = {"Ola", "ala", "Ala", "Marek", "Łukasz", "Ącki", "Alamakota", "Ab", "Żaneta", "Lucek", "Ala", "23"};
		List<String> lista = new ArrayList<>(List.of(tablica));
		
		System.out.println(lista);
		
		// sortowanie listy w sposób domyślny od Javy 8 zapisuje się tak:
		lista.sort(null);
		// w przypadku Stringów oznacza to sortowanie wg kodów Unicode		
		System.out.println(lista);
		
		// Istnieje też taki sposób, dostępny też w starszych wersjach Javy:
		Collections.sort(lista);
		System.out.println(lista);
		
		// Wprowadzenie w temat Comparatorów.
		// Comparator to jest taka maszynka, która (w metodzie compare) jak waga porównuje dwa obiekty
		// Możemy sami stworzyć własny Comparator - tutaj jest to klasa KomparatorDlugosciNapisow
		
		KomparatorDlugosciNapisow komparator = new KomparatorDlugosciNapisow();
		lista.sort(komparator);
		System.out.println(lista);
		
		// Komparatory można też tworzyć jako klasy anonimowe oraz (od Java 8) wyrażenia lambda
		lista.sort((s1, s2) -> s2.length() - s1.length());
		System.out.println(lista);
		System.out.println();
		
		// SORTOWANIE ZGODNE Z ALFABETEM
		// Klasa Collator jest takim gotowym Comparatorem, który porównuje napisy zgodnie z alfabetem jakiegoś ludzkiego języka

		// sortowanie zgodne z bieżącymi ustawieniami komputera:
		lista.sort(Collator.getInstance());
		System.out.println(lista);

		// sortownaie zgodne z określonym językiem
		lista.sort(Collator.getInstance(Locale.FRANCE));
		System.out.println(lista);

		lista.sort(Collator.getInstance(Locale.of("pl", "PL")));
		System.out.println(lista);
		System.out.println();

		// Sortować można też tablice
		// sposób domyślny:
		Arrays.sort(tablica);
		System.out.println(Arrays.toString(tablica));

		// w oparciu o podany komparator:
		Arrays.sort(tablica, Collator.getInstance());
		System.out.println(Arrays.toString(tablica));
		System.out.println();
		
		// Comparator / Collator może być też wykorzystany podczas tworzenia TreeSet i TreeMap
		Set<String> zbior = new TreeSet<>(Collator.getInstance());
		zbior.add("Łukasz");
		zbior.add("Lucek");
		zbior.add("Marek");
		System.out.println(zbior);
	}

}
