package p12_kolekcje;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Scanner;

public class SzukajSlow {

	public static void main(String[] args) {
		// Wczytamy wszystkie linie Pana Tadeusza do listy
		try {
			List<String> lines = Files.readAllLines(Paths.get("pliki", "pan_tadeusz.txt"), Charset.forName("utf-8"));
			System.out.println("Wczytano " + lines.size() + " linie");
			
			// jednorazowo albo w pętli:
			// pytaj użytkownika, jakiego słowa szuka
			// następnie oblicz, w ilu liniach to słowo (ten fragment) występuje i wypisz wynik
			Scanner scanner = new Scanner(System.in);
			while(true) {
				System.out.print("Czego szukasz? ");
				String szukane = scanner.nextLine();
				if(szukane.isEmpty())
					break;
				
				int ile = 0;
				for(String line : lines) {
					if(line.contains(szukane)) {
						ile++;
					}
				}
				System.out.println(ile + " razy");
			}
		
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

}
