package p11_tablice;

import java.util.Arrays;
import java.util.stream.IntStream;

public class Srednia {

	public static void main(String[] args) {
		// Mamy przykładową tablicę, np ocen
		int[] oceny = {5, 4, 4, 3, 4, 3};
		// Oblicz średnią z liczb, które są w tablicy:
		
		// wersja "nieskalowalna", dobra tylko dla kilku elementów
		double srednia1 = (oceny[0] + oceny[1] + oceny[2] + oceny[3] + oceny[4] + oceny[5]) / 6.0;
		System.out.println(srednia1);
		
		// zamiast wypisywać oceny[0], oceny[1] itd, musimy te składniki dodawać w pętli
		// Aby mieć miejsce, do którego można dodawać składniki, tworzymy zmienną typu "skarbonka".
		// W tej wersji stosuję pętlę "for z licznikiem"
		int suma = 0;
		for(int i = 0; i < oceny.length; i++) {
			suma = suma + oceny[i];
		}
		// Zarówno suma, jak i length to są inty. Aby wynik obejmował część ułamkową, trzeba sumę zrzutować na double
		// double srednia2 = (double)suma / oceny.length;
		// Można też pomnożyć przez 1.0
		double srednia2 = 1. * suma / oceny.length;
		System.out.println(srednia2);
		
		// ostatnia wersja: zmienna suma od razu będzie typu double,
		// użyjemy pętli for-each
		double suma3 = 0;
		for(int ocena : oceny) {
			suma3 += ocena;
		}
		double srednia3 = suma3 / oceny.length;
		System.out.println(srednia3);
		
		// Istnieją też gotowe rozwiązania, które w Javie oparte są o tzw. "strumienie"
		double srednia4 = IntStream.of(oceny).average().getAsDouble();
		System.out.println(srednia4);

		double srednia5 = Arrays.stream(oceny).average().orElse(0);
		System.out.println(srednia5);
	}

}
