package p11_tablice;

import java.util.Arrays;

public class A_Wstep {

	public static void main(String[] args) {
		// Zamiast tworzyć wielu oddzielnych zmiennych:
		String miasto1 = "Kraków";
		String miasto2 = "Wrocław";
		String miasto3 = "Łódź";
		
		System.out.println("Miasto nr 1 to " + miasto1);
		
		// można utworzyć tablicę wielu wartości:
		String[] miasta = new String[5];
		// Każdy element tablicy może być traktowany jak zmienna danego typu:
		miasta[1] = "Kraków";
		miasta[2] = "Wrocław";
		miasta[3] = "Łódź";
		System.out.println("Miasto nr 2 to " + miasta[2]);
		
		// Jednak mając dane w tablicy uzyskujemy dodatkowe możliwości:
		// Operacje wykonywane na całej tablicy, np. wypisanie całej tablicy
		// uwaga - taki print nie wypisze zawartości:
		System.out.println(miasta);
		// Aby zobaczyć zawartość, trzeba użyć operacji Arrays.toString()
		System.out.println(Arrays.toString(miasta));
		
		// Przy okazji zauważamy, że numery pozycji w tablicy idą od 0.
		// W tablicy rozmiaru 5 prawidłowe indeksy to liczby od 0 do 4
		// Jeśli nie wpiszemy żadnej wartości w dane miejsce tablicy,
		// to pozostaje tam wartość null (w przypadku typów obiektowych) lub 0 (w przypdaku typów int itp)
		miasta[0] = "Warszawa";
		miasta[4] = "Poznań";
		System.out.println(Arrays.toString(miasta));
		System.out.println();
		
		// Aby wykonać czynność "dla każdego elementu tablicy",
		// można użyć tzw pętli "for-each"
		for(String m : miasta) {
			System.out.println("Pozdrawiamy mieszkańców miasta " + m);
		}
		System.out.println();
		
		// Tworząc tablicę, można też od razu podać jej zawartość:
		int[] t = {5, 10, 15, -5, -10, -15, 0};
		System.out.println("Tablica liczb o rozmiarze " + t.length);
		System.out.println(Arrays.toString(t));
		// przykład pętli, w której modyfikujemy elementy tablicy,
		// zwiększa każdą liczbę o 1:
		for(int i = 0; i < t.length; i++) {
			t[i] += 1;
		}
		
		System.out.println(Arrays.toString(t));
		
		
		/* to by nie zmieniło zawartości tablicy:
		 for(int x : t) {
			x += 1;
		}
		 */
	}

}

/*
int - typ prosty
Integer - typ obiektowy
BigInteger - typ obiektowy , bez ograniczenia na wielkość

tablice - rzecz "niskopoziomowa"
kolekcje: List, Set, Map - klasy, które służą do przechowywania danych,
 "mądrzejsze" od tablic, ale czasami działają wolniej
*/


