package p10_zbieranie_danych;

import java.util.*;

public class P5_Slownik {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // Słownik to struktura, w których przechowywane są pary
        // klucz → wartość
        // Dostęp do danych odbywa się poprzez klucze; klucze są unikalne.
        // Tutaj dla imion (String) będziemy pamiętać wiek danej osoby (Integer).
        Map<String, Integer> slownik = new HashMap<>();

        System.out.println("Podawaj imiona. Zakończ wciskając enter.");
        while(true) {
            System.out.print("Podaj następne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            System.out.print("Podaj wiek: ");
            int wiek = scanner.nextInt();
            scanner.nextLine(); // aby skonsumować znak \n znajdujący za liczbą w buforze wejściowych
            slownik.put(imie, wiek);
        }

        System.out.println(slownik);
        System.out.println();

        for(Map.Entry<String, Integer> entry : slownik.entrySet()) {
            System.out.print(entry.getKey().toUpperCase() + "-" + entry.getValue() + ", ");
        }
        System.out.println();

        // Od Java 8 można też w ten sposób przejrzeć cały słownika:
        slownik.forEach((klucz, wartosc) -> {
            System.out.print(klucz + "=" + wartosc + "; ");
        });
        System.out.println();
        System.out.println();

        System.out.println("Podawaj imiona osób, a ja odczytam ich wiek. Zakończ wciskając enter.");
        while(true) {
            System.out.print("imie: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            // get odczytuje wartość znajdującą się pod podanym kluczem,
            // a gdyby takiego klucza nie było, zwraca null
            System.out.println("osoba " + imie + " ma " + slownik.get(imie) + " lat");

            // częsty bład to próba wpisania  nulla do zmiennej typu prostego
            // int wiek = slownik.get(imie);
            // można ewentualnie tak:
            // Integer wiek = slownik.get(imie);

            // można też najpierw sprawdzić, czy słownik zawiera taki klucz,
            // a później odczytać wartość
            // jest to trochę mnie wydajne, niż odczyt nulla albo defaulta,
            // gdyż mamy tu dwa dostępy do słownika zamiast jedengo:
            if(slownik.containsKey(imie)) {
                System.out.println("osoba " + imie + " należy do słownika i ma " + slownik.get(imie) + " lat");
            } else {
                System.out.println("osoba " + imie + " NIE należy do słownika");
            }
        }
    }
}
