package p10_zbieranie_danych;

import java.util.*;

/* Program gromadzi w pamięci dane wprowadzane przez użytkownika (przykładowo będą to imiona)
   a następnie je wypisuje i pozwala odczytywać je pojedynczo.
 */
public class P3_Zbior {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // W tej wersji dane są zapisywane w zbiorze.
        // Zbiory:
        // - nie zawierają duplikatów (dodanie kolejny raz tej samej wartości nie zmienia już zbioru),
        // - mają prawo zmienić kolejność elementów
        //   → HashSet zmienia kolejność (wg własnych zasad w oparciu o haszkody, na co nie mamy wpływu)
        //   → LinkedHashSet nie zmienia kolejności (zachowuje początkową kolejność, w jakiej elementy były dodawane)
        //   → TreeSet samoczynnie sortuje elementy
        // Podstawową (i wydajną) operacją dla zbioru jest sprawdzenie czy element należy do zbioru.

        Set<String> zbior = new HashSet<>();

        System.out.println("Podawaj imiona. Zakończ wciskając enter.");
        while(true) {
            System.out.print("Podaj następne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            if(zbior.add(imie)) {
                System.out.println("imię " + imie +" zostało dodane");
            } else {
                System.out.println("imię " + imie +" występowało już wcześniej");
            }
        }

        // wypisanie zbioru = jego zawartości
        System.out.println(zbior);
        System.out.println();

        for(String imie : zbior) {
            System.out.print(imie.toUpperCase() + " ");
        }
        System.out.println();
        System.out.println();

        // W przypadku zbiorów najbardziej podstawową operacją odczytu jest sprawdzenie,
        // czy zbiór zawiera wartość. Ta operacja dla zbiorów działa wydajnie.
        System.out.println("Podawaj imiona, a ja sprawdzę, czy je posiadam. Zakończ wciskając enter.");
        while(true) {
            System.out.print("imie: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            if(zbior.contains(imie)) {
                System.out.println("osoba " + imie + " należy do zbioru");
            } else {
                System.out.println("osoba " + imie + " NIE należy do zbioru");
            }
        }
    }
}
