package p10_zbieranie_danych;

import java.util.*;

/* Program gromadzi w pamięci dane wprowadzane przez użytkownika (przykładowo będą to imiona)
   a następnie je wypisuje i pozwala odczytywać je pojedynczo.
 */
public class P2_Lista {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // W tej wersji dane są zapisywane w liście - nie potrzebujemy pytać o rozmiar.
        // Listy:
        // - mogą zawierać duplikaty (tę wartość kilka razy),
        // - przechowują elementy na określonych pozycjach od 0 do size-1,
        //   za pomocą get(i) można odczytać, a za pomocą set(i, nowaWartosc) zmienić konkretny element listy

        List<String> lista = new ArrayList<>();

        System.out.println("Podawaj imiona. Zakończ wciskając enter.");
        for(;;) { // różnoważne while(true)
            System.out.print("Podaj następne imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            lista.add(imie);
        }

        // wypisanie listy = jej zawartości
        System.out.println(lista);
        System.out.println();

        for(String imie : lista) {
            System.out.print(imie.toUpperCase() + " ");
        }
        System.out.println();

        // Od Java 8 można forEach z wyrażeniem lambda
        lista.forEach(imie -> System.out.print(imie + "; "));
        System.out.println();

        System.out.println();

        System.out.println("Podawaj numer pozycji, a zakończ pisząc -1");
        while(true) {
            System.out.print("numer: ");
            int nr = scanner.nextInt();
            if(nr < 0) break;
            if(nr >= lista.size()) {
                System.out.println("Indeks poza zakresem");
                continue;
            }
            System.out.println("osoba nr " + nr + " = " + lista.get(nr));
        }
    }
}
