package p10_zbieranie_danych;

import java.util.Arrays;
import java.util.Scanner;

/* Program gromadzi w pamięci dane wprowadzane przez użytkownika (przykładowo będą to imiona)
   a następnie je wypisuje i pozwala odczytywać je pojedynczo.
 */
public class P1_Tablica {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        // W tej wersji dane są zapisywane w tablicy.
        // Tworząc tablicę musimy podać jej rozmiar, który później się nie zmienia (można ew. stworzyć większą tablicę).
        System.out.print("Ile imion podasz? ");
        int size = scanner.nextInt();
        String[] tablica = new String[size];
        for(int i = 0; i < size; i++) {
            System.out.print("Podaj imię nr " + i + ": ");
            tablica[i] = scanner.next();
        }

        // wypisanie tablicy i jej zawartości
        System.out.println(tablica);
        System.out.println(Arrays.toString(tablica));
        System.out.println();

        // dwa rodzaje pętli
        // - for z licznikiem - użyte powyżej do wprowadzania danych do tablicy
        // - for each
        for(String imie : tablica) {
            System.out.print(imie.toUpperCase() + " ");
        }
        System.out.println();
        System.out.println();

        // Drugi etap: użytkownik podaje numer, a program odczytuje wartość z podanej pozycji.
        System.out.println("Podawaj numer pozycji, a zakończ pisząc -1");
        while(true) {
            System.out.print("numer: ");
            int nr = scanner.nextInt();
            if(nr < 0) break;
            if(nr >= tablica.length) {
                System.out.println("Indeks poza zakresem");
                continue;
            }
            System.out.println("osoba nr " + nr + " = " + tablica[nr]);
        }
    }
}
