package p07_funkcje;

// Ta klasa zawiera wyłącznie metody statyczne.
// Na takie klasy mówi się często "klasa narzędziowa" / "utility class".
// Odpowiada to modułowi zawierającemu funkcje z innych języków (C, Python, PHP itp).
// Po prostu w Javie funkcje definiuje się zawsze wewnątrz klasy.
public class Geometria {
	// blok statyczny zostanie wykonany, gdy maszyna wirtualna załaduje klasę do pamięci
	static {
		System.out.println("Klasa Geometria się załadowała");
	}

	// Opcjonalnie w takich klasach możemy zmienić konstruktor na prywatny,
	// aby nikt nie mógł stworzyć obiektu tej klasy
	private Geometria() { }
	
	public static double poleKwadratu(double a) {
		return a*a;
	}

	public static double obwodKwadratu(double a) {
		return 4*a;
	}

	public static double poleProstokata(double a, double b) {
		return a*b;
	}

	public static double obwodProstokata(double a, double b) {
		return 2*a + 2*b;
	}
	
	public static double poleKola(double r) {
		return Math.PI * r*r;
	}
	
	public static double obwodKola(double r) {
		return Math.PI * 2*r;
	}
	
	public static boolean warunekTrojkata(double a, double b, double c) {
		return a < b + c && b < a + c && c < a + b;
	}
	
	public static double poleTrojkata(double a, double b, double c) {
		double p = obwodTrojkata(a, b, c) / 2;
		return Math.sqrt(p*(p-a)*(p-b)*(p-c));
	}
	
	public static double obwodTrojkata(double a, double b, double c) {
		return a + b + c;
	}

}
