package p07_funkcje;

import java.util.Scanner;

public class Fibonacci {
	
	// Ciąg Fibonacciego: na pozycji 0 jest wynik 0, na pozycji 1 jest wynik 1,
	// a każda kolejna liczba Fibonacciego jest sumą dwóch poprzednich
	// 0 1 1 2 3 5 8 13 21 34 55
	// F(9) = 34
	static long fibr(int n) {
		if(n <= 1)
			return n;
		return fibr(n-1) + fibr(n-2);
	}
	
	static long fib(int n) {
		long ostatnia = 0;
		long przedostatnia = 1;
		for(int i = 1; i <= n; i++) {
			long nowa = ostatnia + przedostatnia;
			przedostatnia = ostatnia;
			ostatnia = nowa;
		}
		return ostatnia;
	}

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		while(true) {
			System.out.println("Podaj liczbę: ");
			int n = scanner.nextInt();
			if(n < 0) break;
			// System.currentTimeMillis()
			long p = System.nanoTime();
			var wynik = fib(n);
			long k = System.nanoTime();
			System.out.printf("F(%d) = %d, czas %.3fs%n", n, wynik, (k-p) * 1e-9);
		}
	}

}
