package p06_enkapsulacja;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class Student extends Osoba {
    private String kierunek;
    private int rok;
    private List<Integer> oceny = new ArrayList<>();

    public void dodajOcene(int ocena) {
        oceny.add(ocena);
    }

    public double getSredniaOcen() {
        if(oceny.isEmpty()) {
            return 0;
        }
        int suma = 0;
        for(int ocena : oceny) {
            suma += ocena;
        }
        return (double)suma / oceny.size();
    }

    public Student(String imie, String nazwisko, LocalDate dataUrodzenia, String kierunek, int rok) {
        super(imie, nazwisko, dataUrodzenia);
        this.kierunek = kierunek;
        this.rok = rok;
    }

    // Jeśli chciałbym konstruktor z datą jako String, to mogę to zrobić na dwa sposoby (albo super, albo this):
    public Student(String imie, String nazwisko, String dataUrodzenia, String kierunek, int rok) {
        super(imie, nazwisko, dataUrodzenia);
        this.kierunek = kierunek;
        this.rok = rok;
    }

//    public Student(String imie, String nazwisko, String dataUrodzenia, String kierunek, int rok) {
//        this(imie, nazwisko, LocalDate.parse(dataUrodzenia), kierunek, rok);
//    }


    public String getKierunek() {
        return kierunek;
    }

    public void setKierunek(String kierunek) {
        this.kierunek = kierunek;
    }

    public int getRok() {
        return rok;
    }

    public void setRok(int rok) {
        this.rok = rok;
    }

    public int getLiczbaOcen() {
        return oceny.size();
    }

    @Override
    public String toString() {
        return super.toString() + ", student " + rok + " roku kierunku " + kierunek;
    }
}
