package p06_enkapsulacja;

import java.time.LocalDate;
import java.time.Period;
import java.util.Objects;

public class Osoba {
    public static final int WIEK_PELNOLETNIOSCI = 18;

    private String imie, nazwisko;
    private LocalDate dataUrodzenia;

    public Osoba(String imie, String nazwisko, LocalDate dataUrodzenia) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.setDataUrodzenia(dataUrodzenia);
    }

    public Osoba(String imie, String nazwisko, String dataUrodzenia) {
        this(imie, nazwisko, LocalDate.parse(dataUrodzenia));
    }

    public String getImie() {
        return imie;
    }

    public void setImie(String imie) {
        this.imie = imie;
    }

    public String getNazwisko() {
        return nazwisko;
    }

    public void setNazwisko(String nazwisko) {
        this.nazwisko = nazwisko;
    }

    public LocalDate getDataUrodzenia() {
        return dataUrodzenia;
    }

    public void setDataUrodzenia(LocalDate dataUrodzenia) {
        Objects.requireNonNull(dataUrodzenia);
        this.dataUrodzenia = dataUrodzenia;
    }

    @Override
    public String toString() {
        return imie + " "  + nazwisko + " ur." + dataUrodzenia;
    }

    public int getWiek() {
        Period czasZycia = Period.between(dataUrodzenia, LocalDate.now());
        return czasZycia.getYears();
    }

    public final boolean pelnoletnia() {
        return getWiek() >= WIEK_PELNOLETNIOSCI;
    }

}
