package p05_klasy_wstep;

public class Program4_Student {

    public static void main(String[] args) {
        Osoba osoba = new Osoba();
        osoba.imie = "Ala";
        osoba.nazwisko = "Kowalska";
        osoba.wiek = 30;
        osoba.przedstawSie();

        Student student = new Student();
        // obiekt klasy Student posiada wszystkie te pola i metody, które posiada obiekt Osoba
        // a dodatkowo posiada elementy zdefiniowane w kl. Student, których nie posiadają pozostałe Osoby
        student.imie = "Adam";
        student.nazwisko = "Abacki";
        student.wiek = 20;

        student.kierunek = "geologia";
        student.przedstawSie();

        student.dodajOcene(3);
        student.dodajOcene(4);
        System.out.println(student.sredniaOcen());
        // osoba.kierunek = "matematyka";
        System.out.println();

        // Dziedziczenie w Javie onacza nie tylko techniczne przejęcie pól i metod klasy Osoba przez klasę Student.
        // Jest to także zależność logiczna mówiąca, że Student jest Osobą.
        // W programowaniu to oznacza, że jeśli gdzieś można użyć wartości typu Osoba,
        // to można też użyć wartości typu Student i kod nadal będzie się kompilował. "zasada podstawiania"

        // Studenta można wpisać do zmiennej typu Osoba (po co? - nie wiem, ale można)
        Osoba ktos = student;
        System.out.println(ktos);
        System.out.println(ktos.imie);
        // System.out.println(ktos.kierunek);
        ktos.przedstawSie();
        System.out.println();

        // student może być właścicielem konta:
        Konto kontoStudenckie = new Konto(1, student, 500);
        System.out.println(kontoStudenckie);

        // student może pójść do sklepu
        Sklep sklep = new Sklep("Lidl", 5);
        sklep.sprzedajPiwo(osoba);
        sklep.sprzedajPiwo(student);
        System.out.println();

        // Konstruktory nie są dziedziczone
        // Z faktu, że istnieje konstruktor Osoba(String, String, int)
        // nie wynika istnienie takiego konstruktora dla klasy Student
        // Student student2 = new Student("Bartek", "Babacki", 22);

        Student student3 = new Student("Bartek", "Babacki", 22, "informatyka", 3);
        System.out.println(student3);
    }
}
