package p05_klasy_wstep;

public class Osoba {
    /* W klasach można umieszczać:
      - zmienne - statyczne lub "instancyjne"; na zmienne w klasach mówi się też "pola" lub "atrybuty"
      - metody - statycznych lub instancyjnych
      - konstruktory
      - bloki inicjalizacyjne - statyczne lub instancyjne
      - klasy zagnieżdżone - statyczne lub instancyjne
        - szczególnym przypadkiem mogą być zagieżdżone interfejsy, enumy, rekordy - niektóre z nich są tylko statyczne
     */

    // zmienne (pola) deklarowane bez słowa static należą do obiektów danej klasy (każdy obiekt ma swoje pola)
    String imie, nazwisko;
    int wiek;

    // jeśli przed zmienną jest słowo static, to taka zmienna należy do klasy,
    // a nie do poszczególnych obiektów
    // w pamięci istnieje jeden egzemplarz tej zmiennej
    static final int WIEK_PELNOLETNIOSCI = 18;

    private static int liczbaObiektow = 0;

    // konstruktor to taka specjalna metoda, która jest wykonywana
    // podczas tworzenia nowego obiektu

    Osoba() {
    }

    Osoba(String imie, String nazwisko, int wiek) {
        this.imie = imie;
        this.nazwisko = nazwisko;
        this.wiek = wiek;
    }

    // blok inicjalizacyjny to fragment kodu wykonywany podczas
    // tworzenia każdego obiektu jeszcze przed konstruktorem
    {
        System.out.println("init Osoba");
        liczbaObiektow++;
    }

    // statyczny blok inicjalizacyjny jest wykonywany raz dla danej klasy
    // gdy ta klasa jest ładowana do JVM
    static {
        System.out.println("static Osoba");
    }

    // metoda instancyjna (czyli bez słowa static) będzie uruchamiana na konkretnych obiektach
    // i ma dostęp do pól tego obiektu
    void przedstawSie() {
        System.out.println("Nazywam się " + imie + " " + nazwisko + " i mam " + wiek + " lat.");
        // można też tak, ale w Javie nie ma takiego obowiązku:
        // System.out.println("Nazywam się " + this.imie + " " + this.nazwisko + " i mam " + this.wiek + " lat.");
    }

    int liczbaZnakow() {
        int imieLength = imie == null ? 0 : imie.length();
        int nazwiskoLength = nazwisko == null ? 0 : nazwisko.length();
        return imieLength + nazwiskoLength;
    }

    final boolean pelnoletnia() {
        return wiek >= WIEK_PELNOLETNIOSCI;
    }

    static int liczbaObiektow() {
        return liczbaObiektow;
    }

    @Override
    public String toString() {
        return imie + " " + nazwisko + " (" + wiek + " lat)";
    }

}
