package p03_sterowanie;

import java.util.List;

public class TeoriaPetli {

	public static void main(String[] args) {
		// GENERALNIE pętla umożliwia wielokrotnie wykonanie fragmentu programu
		// Np zamiast 5 razy powtarzac to samo w kodzie:
		System.out.println("Ala ma kota");
		System.out.println("Ala ma kota");
		System.out.println("Ala ma kota");
		System.out.println("Ala ma kota");
		System.out.println("Ala ma kota");
		System.out.println();
		
		// można napisać pętlę, która wykona się 5 razy:
		for(int i = 0; i < 5; i++) {
			System.out.println("Ola ma psa");
		}
		System.out.println();
		
		// W Javie są takie rodzaje pętli: while, do-while, for, for-each
		System.out.println("Pętla while:");
		// while(WARUNEK) { INSTRUKCJE }
		// Gdy WARUNEK jest prawdziwy, to wykonują się INSTRUKCJE,
		//   a następnie ponownie sprawdzany jest WARUNEK, itd...
		// Gdy WARUNEK jest fałszywy, to program przechodzi do dalszej części
		int a = 1;
		while(a <= 5) {
			System.out.println("a = " + a);
			a++;
		}
		System.out.println("Koniec pętli while. Aktualnie a = " + a);

		System.out.println("\nPętla do-while:");
		// do { INSTRUKCJE } while(WARUNEK);
		// Na początku wykonywane są INSTRUKCJE, a następnie
		// sprawdzany jest WARUNEK i:
		// - jeśli jest prawdziwy, do następuje powrót na początek i ponowne wykonanie INSTRUKCJI itd...
		// - jeśli jest fałszywy, to program idzie dalej
		int b = 1;
		do {
			System.out.println("b = " + b);
			b++;
		} while(b <= 5);
		System.out.println("Koniec pętli do-while. Aktualnie b = " + b);
		
		System.out.println("\nPętla for:");
		// for(INICJALIZACJA; WARUNEK; KROK) { INSTRUKCJE }
		// Na początku raz wykonywana jest INICJALIZACJA
		// (może to być deklaracja zmiennej)
		// Następnie - podobnie jak w pętli while - sprawdzany jest WARUNEK
		// - jeśli prawdziwy, to wykonywane są INSTRUKCJE, a następnie dodatkowo KROK
		// - jeśli fałszywy, to idziemy za pętlę
		
		// Najbardziej typowy przykład: przeglądanie zakresu liczbowego:
		for(int i = 1; i <= 5; i++) {
			System.out.println("i = " + i);
		}
		// Jeśli zmienną deklarowaliśmy wewnątrz pętli (a tak jest najczęściej),
		// to teraz nie ma już do niej dostępu.
		// System.out.println("Koniec pętli for, i = " + i);
		System.out.println("Koniec pętli for");
		
		List<String> lista = List.of("Ala", "Ola", "Ela");
		System.out.println("\nPętla for-each");
		// Od Java 5
		// for(Typ zmienna : kolekcja) { INSTRUKCJE }
		// Wykonuje podane instrukcje dla każdego elementu kolekcji (może to być też tablica)
		for(String imie : lista) {
			System.out.println("Witaj " + imie);
		}
		System.out.println();
		
		// Od Java 8 istnieje jeszcze metoda forEach, która formalnie nie jest pętlą,
		// ale można jej użyć zamiasta pętli
		// To coś ze strzałką, to jest "wyrażenie lambda"
		lista.forEach(imie -> System.out.println("Cześć " + imie));
	}

}
