package com.example.demo.rest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import com.example.demo.model.Ogloszenie;
import com.example.demo.repo.OgloszeniaRepository;

@RestController
@RequestMapping(path="/rest/ogloszenia", produces="application/json")
public class ROgloszenia {
    @Autowired
    private OgloszeniaRepository ogloszeniaRepository;
    
    @GetMapping
    public Iterable<Ogloszenie> readAll() {
        return ogloszeniaRepository.findAll();
    }
    
    @GetMapping("/{id}")
    public Ogloszenie readOne(@PathVariable("id") long id) {
        return ogloszeniaRepository.findById(id)
                .orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}
