package com.example.demo.rest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.model.Customer;
import com.example.demo.repo.CustomerRepository;

@RestController
@RequestMapping(path="/rest/customers", produces="application/json")
public class RCustomers {
    @Autowired
    private CustomerRepository customerRepository;
    
    @GetMapping
    public Iterable<Customer> readAll() {
        return customerRepository.findAll();
    }
    
    @GetMapping("/{id}")
    public Customer readOne(@PathVariable("id") long id) {
        return customerRepository.findById(id);
    }
}
