package com.example.demo.repo;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.example.demo.model.Customer;
import com.example.demo.model.Ogloszenie;
import com.example.demo.model.OgloszenieMieszkaniowe;
import com.example.demo.model.OgloszenieSamochodowe;
import com.example.demo.model.OgloszenieSamochodowe.Paliwo;

@Service
public class DBService {

    @Autowired
    private CustomerRepository customerRepository;

    @Autowired
    private OgloszeniaRepository ogloszeniaRepository;

    public void initDatabase() {
        customerRepository.save(new Customer("Jack", "Bauer"));
        customerRepository.save(new Customer("Chloe", "O'Brian"));
        customerRepository.save(new Customer("Kim", "Bauer"));
        customerRepository.save(new Customer("David", "Palmer"));
        customerRepository.save(new Customer("Michelle", "Dessler"));
        
        List<Ogloszenie> ogloszenia = List.of(
                new Ogloszenie("Sprzedam rower", 500),
                new Ogloszenie("Oddam biurko", 0),
                new OgloszenieSamochodowe(25900, "Toyota", "Yaris", 150_000, "HYBRYDA"),
                new OgloszenieSamochodowe(33300, "Volkswagen", "Passat", 290_000, "ON"),
                new OgloszenieMieszkaniowe("Kawalerka w centrum", 790_000, "Warszawa", 5, 39.9, true)
        );
        
        ogloszeniaRepository.saveAllAndFlush(ogloszenia);
    }
}
