package com.example.demo.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import jakarta.persistence.Entity;

@Entity
public class OgloszenieSamochodowe extends Ogloszenie {
    private String marka, model;
    private Integer stanLicznika;
    private Paliwo paliwo;
    
    public OgloszenieSamochodowe() {
        
    }

    public OgloszenieSamochodowe(Long id, String tytul, BigDecimal cena, LocalDateTime dataWystawienia, String marka,
            String model, Integer stanLicznika, Paliwo paliwo) {
        super(id, tytul, cena, dataWystawienia);
        this.marka = marka;
        this.model = model;
        this.stanLicznika = stanLicznika;
        this.paliwo = paliwo;
    }

    public OgloszenieSamochodowe(int cena, String marka, String model, Integer stanLicznika, String paliwo) {
        super(marka + " " + model, cena);
        this.marka = marka;
        this.model = model;
        this.stanLicznika = stanLicznika;
        this.paliwo = Paliwo.valueOf(paliwo);
    }

    public String getMarka() {
        return marka;
    }

    public void setMarka(String marka) {
        this.marka = marka;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getStanLicznika() {
        return stanLicznika;
    }

    public void setStanLicznika(Integer stanLicznika) {
        this.stanLicznika = stanLicznika;
    }

    public Paliwo getPaliwo() {
        return paliwo;
    }

    public void setPaliwo(Paliwo paliwo) {
        this.paliwo = paliwo;
    }
    
    

    @Override
    public String toString() {
        return "OgloszenieSamochodowe [id=" + getId() + ", tytul=" + getTytul() + ", cena=" + getCena()
                + ", dataWystawienia=" + getDataWystawienia() + ", marka=" + marka + ", model=" + model
                + ", stanLicznika=" + stanLicznika + ", paliwo=" + paliwo + "]";
    }



    public static enum Paliwo {
        BENZYNA,
        ON,
        GAZ,
        HYBRYDA,
        ELEKTRYK,
    }
}
