package com.example.demo.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import jakarta.persistence.Entity;

@Entity
public class OgloszenieMieszkaniowe extends Ogloszenie {
    private String miasto;
    private int pietro;
    private double metraz;
    private boolean winda;
    
    public OgloszenieMieszkaniowe() {
        
    }

    public OgloszenieMieszkaniowe(Long id, String tytul, BigDecimal cena, LocalDateTime dataWystawienia, String miasto,
            int pietro, double metraz, boolean winda) {
        super(id, tytul, cena, dataWystawienia);
        this.miasto = miasto;
        this.pietro = pietro;
        this.metraz = metraz;
        this.winda = winda;
    }

    public OgloszenieMieszkaniowe(String tytul, int cena, String miasto,
            int pietro, double metraz, boolean winda) {
        super(tytul, cena);
        this.miasto = miasto;
        this.pietro = pietro;
        this.metraz = metraz;
        this.winda = winda;
    }

    public String getMiasto() {
        return miasto;
    }

    public void setMiasto(String miasto) {
        this.miasto = miasto;
    }

    public int getPietro() {
        return pietro;
    }

    public void setPietro(int pietro) {
        this.pietro = pietro;
    }

    public double getMetraz() {
        return metraz;
    }

    public void setMetraz(double metraz) {
        this.metraz = metraz;
    }

    public boolean isWinda() {
        return winda;
    }

    public void setWinda(boolean winda) {
        this.winda = winda;
    }

    @Override
    public String toString() {
        return "OgloszenieMieszkaniowe [id=" + getId() + ", tytul=" + getTytul() + ", cena=" + getCena()
                + ", dataWystawienia=" + getDataWystawienia() + ", miasto=" + miasto + ", pietro=" + pietro
                + ", metraz=" + metraz + ", winda=" + winda + "]";
    }

}
