package com.example.demo.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;

@Entity
public class Ogloszenie {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private String tytul;
    private BigDecimal cena;
    private LocalDateTime dataWystawienia;
    
    public Ogloszenie() {
        
    }
    
    public Ogloszenie(Long id, String tytul, BigDecimal cena, LocalDateTime dataWystawienia) {
        this.id = id;
        this.tytul = tytul;
        this.cena = cena;
        this.dataWystawienia = dataWystawienia;
    }

    public Ogloszenie(String tytul, int cena) {
        this(null, tytul, BigDecimal.valueOf(cena).setScale(2), LocalDateTime.now());
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTytul() {
        return tytul;
    }

    public void setTytul(String tytul) {
        this.tytul = tytul;
    }

    public BigDecimal getCena() {
        return cena;
    }

    public void setCena(BigDecimal cena) {
        this.cena = cena;
    }

    public LocalDateTime getDataWystawienia() {
        return dataWystawienia;
    }

    public void setDataWystawienia(LocalDateTime dataWystawienia) {
        this.dataWystawienia = dataWystawienia;
    }

    @Override
    public String toString() {
        return "Ogloszenie [id=" + id + ", tytul=" + tytul + ", cena=" + cena + ", dataWystawienia=" + dataWystawienia + "]";
    }    

}
