package com.example.demo;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import jakarta.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HelloController {
	
	@RequestMapping("/")
	public String root() {
		return "index.html";
	}
	
	@RequestMapping("/hello")
	public String hello(Model model) {
		model.addAttribute("txt", "Hello world!");
		model.addAttribute("time", LocalTime.now());
		return "hello.html";
	}
	
    @RequestMapping("/ping")
    public String ping(HttpServletRequest request, Model model) {
        // Do modelu można też dodać słownik / mapę.
        // Odczyt wartości wygląda później np. tak ${clientInfo.userAgent}
        
        String ip = request.getRemoteAddr();
        System.out.println("Zapytanie z adresu " + ip);
        
        model.addAttribute("clientInfo", Map.of(
                    "userAgent", request.getHeader("User-Agent"),
                    "ip", ip,
                    "data", LocalDateTime.now()
                ));
        return "ping.html";
    }
}
