package stare_przyklady;

import java.util.List;

import javax.swing.JOptionPane;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import model.Employee;

public class Odczyt06_Warunek {

	public static void main(String[] args) {

		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			emf = Persistence.createEntityManagerFactory("hr_postgresql");
			em = emf.createEntityManager();
			
			String kogoSzukam = JOptionPane.showInputDialog("Podaj kod stanowiska");
			
			// to działało:
			// TypedQuery<Employee> query = em.createQuery("SELECT emp FROM Employee emp WHERE job.jobId = ?1", Employee.class);
			// query.setParameter(1, kogoSzukam);

			// ale to już nie ("legacy parameter style"):
			// TypedQuery<Employee> query = em.createQuery("SELECT emp FROM Employee emp WHERE job.jobId = ?", Employee.class);
			// query.setParameter(1, kogoSzukam);

			// wszystkie trzy zapisy zadziałały:
			// TypedQuery<Employee> query = em.createQuery("SELECT emp FROM Employee emp WHERE job_id = :kto", Employee.class);
			// TypedQuery<Employee> query = em.createQuery("SELECT emp FROM Employee emp WHERE job.jobId = :kto", Employee.class);
			TypedQuery<Employee> query = em.createQuery("SELECT emp FROM Employee emp WHERE emp.job.jobId = :kto", Employee.class);
			query.setParameter("kto", kogoSzukam);
			
			List<Employee> lista = query.getResultList();
			System.out.println("Ilość rekordów " + lista.size());
			for (Employee employee : lista) {
				System.out.println(employee.getFirstName() + " " + employee.getLastName());
				//System.out.println(employee.getJob());
			}
			
		} finally {
			if (em != null)
				em.close();
			if (emf != null)
				emf.close();
		}
	}
}
