package programy;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import model.Location;

public class P04_OdczytajStream {

    public static void main(String[] args) {
        EntityManagerFactory emf = null;
        EntityManager em = null;
        // Zapis z użyciem strumienia może dać lepszą wydajność. Zwróć uwagę na kolejność wykonywania dodatkowych selectów
        try {
            emf = Persistence.createEntityManagerFactory("hr_postgresql");
            em = emf.createEntityManager();
            em.createNamedQuery("Location.findAll", Location.class)
                    .getResultStream()
                    .map(loc -> String.format(" - %s, %s %s, %s", loc.getStreetAddress(), loc.getPostalCode(), loc.getCity(),
                        loc.getCountry().getCountryName()))
                    .forEach(System.out::println);
        } finally {
            em.close();
            emf.close();            
        }
    }

}
