package sklep.przyklady_hibernate;

import java.util.List;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import sklep.model.Product;

public class Parametry {

	public static void main(String[] args) {
		try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
			EntityManager em = emf.createEntityManager()) {
			
			int min = 1000;
			int max = 3000;
			
			String jpql = """
					SELECT p FROM Product p
					WHERE p.price BETWEEN :minPrice AND :maxPrice
					ORDER BY p.price DESC
			""";
			TypedQuery<Product> query = em.createQuery(jpql, Product.class);
			query.setParameter("minPrice", min);
			query.setParameter("maxPrice", max);

			List<Product> products = query.getResultList();
			System.out.printf("Mam %d produktów:\n", products.size());
			
			for(Product product : products) {
				System.out.printf("%s za cenę %s\n", product.getProductName(), product.getPrice());
			}
		}
	}

}
