package sklep.przyklady_hibernate;

import java.util.List;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import sklep.model.Product;

public class OdczytajListe_JPQL {

	public static void main(String[] args) {
		try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
			EntityManager em = emf.createEntityManager()) {
			
			// Zapytanie w języku JPQL (Java/Jakarta Persistence Query Language)
			// Można też spotkać skrót HQL = Hibernate Query Language
			TypedQuery<Product> query = em.createQuery("SELECT p FROM Product p ORDER BY p.productName", Product.class);
			List<Product> products = query.getResultList();
			System.out.printf("Mam %d produktów:\n", products.size());
			
			for(Product product : products) {
				System.out.printf("%s za cenę %s\n", product.getProductName(), product.getPrice());
			}
		}
	}

}
