package sklep.przyklady_hibernate;

import java.util.Scanner;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

import sklep.model.Product;

public class OdczytajJedenProdukt {

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		
		try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
			EntityManager em = emf.createEntityManager()) {
			System.out.println("Mam EntityManagera: " + em);
			
			while(true) {
				int id = sc.nextInt();
				if(id == 0)
					break;
				Product product = em.find(Product.class, id);
				if(product == null) {
					System.out.printf("Nie ma produktu o numerze %d\n", id);
					continue;
				}
				System.out.println("Mam obiekt: " + product);
				System.out.printf("Produkt nr %d to %s za cenę %s\n",
						product.getProductId(), product.getProductName(), product.getPrice());
				if(product.getDescription() != null) {
					System.out.printf("Opis: %s\n", product.getDescription());
				}
			}
		}
	}

}
