<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="jakarta.tags.core"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Przykład JSP 2</title>
</head>
<body>
<h1>Przykładowe JSP 2</h1>
<p>Mądrzejszy sposób korzystania z JSP łączy takie trzy techniki:</p>
<ol>
<li><strong>Expression Language (EL)</strong> - wyrażenia wpisywane w znacznikach <code>$ { }</code>,
<li><strong>beans</strong> - obiekty przygotowane po stronie aplikacji lub w samym skrypcie JSP, do których JSP ma dostęp,
<li><strong>taglibs</strong> - biblioteki dodatkowych tagów, które działają jak polecenia, chociaż są pisane jak tagi HTML.
</ol>

<h3>EL</h3>
<%-- proste wyrażenie EL --%>
<p>Wynik obliczenia: ${2 + 3 * 4}</p>

<h3>Bean</h3>
<jsp:useBean id="obiekt" class="beans.PrzykladowyBean"/>
<p>Obiekt beanowy: ${obiekt}</p>
<p>Odczyt napisu: ${obiekt.napis}</p>
<p>Duże litery: ${obiekt.napisDuzymiLiterami}</p>
<%-- Można wywoływać metody o nazwach niezgodnych z konwencją getterów: --%>
<p>Wywołanie metody: ${obiekt.wylosuj()}</p>

<jsp:setProperty property="napis" name="obiekt" value="Ola ma psa"/>
<p>Napis po zmianie: ${obiekt.napis}</p>
<p>Duże litery: ${obiekt.napisDuzymiLiterami}</p>
<%-- Gdy wpisujemy odwołanie do obiektu, to jest on printowany za pomocą toString().
    Gdy wpiszemy coś, co wygląda na odczyt pola obiektu, to jest wywoływany getter zwracający to property,
    np. osoba.wiek powoduje wywołanie getWiek()
    Gdy wpiszemy coś z nawiasami na końcu, to jest to wywołanie metody.
    Polecenie setProperty skutkuje wywołaniem settera, np. setNapis(...)
--%>


<%-- Biblioteka tagów ("taglib") to jest zestaw poleceń zapisywanych w formie znaczników w obrębie JSP.
Te znaczniki zawsze są poprzedzane prefiksem, np. <c:if>....

Tagliby można definiować samodzielnie, ale w 98% przypadków używa się zestawu nazywanego JSTL
"Java Standard Tag Library"
--%>
<h3>Taglibs</h3>
<ul>
<c:forEach var="i" items="5,10,15">
    <li>${i}
        <c:choose>
            <c:when test="${i % 2 == 0}">parzyste</c:when>
            <c:otherwise>nieparzyste</c:otherwise>
        </c:choose>
    </li>
</c:forEach>
</ul>

<p>Słowa napisu:</p>
<ul>
<c:forEach var="word" items="${obiekt.words}">
	<li>${word}</li>
</c:forEach>
</ul>

</body>
</html>
