package podstawy;

import java.io.IOException;
import java.io.PrintWriter;

import org.apache.commons.lang3.StringUtils;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator")
public class Kalkulator extends HttpServlet {
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		out.println("""
				<!DOCTYPE html>
				<html>
					<head>
						<title>Kalkulator</title>
						<link rel="stylesheet" href="styl.css">
					</head>
					<body>
						<h1>Kalkulator serwletowy</h1>
		""");
		
		out.println("""
				<form>
	                <input name="liczba1" type="number">
	                <select name="operacja">
	                    <option value='+'>+</option>
	                    <option value='-'>-</option>
	                    <option value='*'>*</option>
	                    <option value='/'>/</option>
	                </select>
	                <input name="liczba2" type="number">
	                <br/>
	                <button>Oblicz</button>
				</form>
				""");
		
		String arg1 = request.getParameter("liczba1");
		String arg2 = request.getParameter("liczba2");
		String operacja = request.getParameter("operacja");
		
		if(StringUtils.isNoneBlank(arg1, arg2, operacja)) {
			long liczba1 = Long.parseLong(arg1);
			long liczba2 = Long.parseLong(arg2);
			long wynik = oblicz(liczba1, liczba2, operacja);
			out.printf("<div class='wynik'>%d %s %d = <strong>%d</strong></div>",
					liczba1, operacja, liczba2, wynik);
		}
		out.println("</body></html>");
	}
	
    private long oblicz(long liczba1, long liczba2, String operacja) {
        return switch(operacja) {
            case "+" -> liczba1 + liczba2;
            case "-" -> liczba1 - liczba2;
            case "*" -> liczba1 * liczba2;
            case "/" -> liczba1 / liczba2;
            default -> 0;
        };
    }
}
