package watki.na_zajeciach;

import watki.na_zajeciach.Konto.BrakSrodkow;

public class Wyplacanie1 {

	public static void main(String[] args) {
		final int ILE_RAZY = 100_000;
		final int KWOTA = 10;
		
		Konto konto = new Konto(1, 1000000, "Ala");
		System.out.println("Początek: " + konto);
		
		Thread wplacacz = new Thread(() -> {
			for(int i = 0; i < ILE_RAZY; i++) {
				konto.wplata(KWOTA);
			}
		});

		Thread wyplacacz = new Thread(() -> {
			for(int i = 0; i < ILE_RAZY; i++) {
				try {
					konto.wyplata(KWOTA);
				} catch (BrakSrodkow e) {
					System.err.println(e);
				}
			}
		});

		System.out.println("Uruchamiam wątki...");
		wplacacz.start();
		wyplacacz.start();
		
		System.out.println("Czekam...");
		try {
			wplacacz.join();
			wyplacacz.join();
		} catch (InterruptedException e) {
			System.err.println(e);
		}
		
		System.out.println("Koniec: " + konto);
	}

}
