package watki.na_zajeciach;

public class Konto {
	private final int numer;
	private int saldo;
	private String wlasciciel;

	public Konto(int numer, int saldo, String wlasciciel) {
		this.numer = numer;
		this.saldo = saldo;
		this.wlasciciel = wlasciciel;
	}

	@Override
	public String toString() {
		return "Konto nr " + numer + ", saldo " + saldo + ", wł. " + wlasciciel;
	}

	public String getWlasciciel() {
		return wlasciciel;
	}

	public void setWlasciciel(String wlasciciel) {
		this.wlasciciel = wlasciciel;
	}

	public int getNumer() {
		return numer;
	}

	public int getSaldo() {
		return saldo;
	}

	public synchronized void wplata(int kwota) {
		if (kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		saldo += kwota;
		notify();
	}

	// Ta wersja metody w przypadku braku środków wyrzuca wyjątek BrakSrodkow
	public synchronized void wyplata(int kwota) throws BrakSrodkow {
		if (kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		if (kwota > saldo) {
			throw new BrakSrodkow("Za mało kasy podczas wypłaty");
		}
		saldo -= kwota;
	}
	
	// Ta wersja metody w przypadku braku środków będzie czekać, aż pieniądze pojawią się na koncie.
	public synchronized void wyplataCzekaj(int kwota) throws BrakSrodkow {
		if (kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		try {
			while(kwota > saldo) {
				wait();
			}
			saldo -= kwota;
			notify();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	public void przelew(int kwota, Konto kontoDocelowe) throws BrakSrodkow {
		if (kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		synchronized (this) {
			if (kwota > saldo) {
				throw new BrakSrodkow("Za mało kasy podczas przelewu");
			}
			this.saldo -= kwota;			
		}
		synchronized (kontoDocelowe) {
			kontoDocelowe.saldo += kwota;
			kontoDocelowe.notify();
		}
	}

	public static class BrakSrodkow extends Exception {
		public BrakSrodkow() {
			super();
		}

		public BrakSrodkow(String message) {
			super(message);
		}
	}
}
