package sklep.klient;

import java.util.Scanner;

import sklep.generated.DBException_Exception;
import sklep.generated.Product;
import sklep.generated.RecordNotFound_Exception;
import sklep.generated.Sklep;
import sklep.generated.SklepService;

public class OdczytajJedenProdukt {

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		SklepService service = new SklepService();
		Sklep sklep = service.getSklepPort();
		
		while(true) {
			System.out.println("Podaj ID produktu lub 0, aby zakończyć");
			int id = scanner.nextInt();
			if(id == 0) break;
			try {
				Product product = sklep.readOne(id);
				System.out.println("Znaleziono produkt: " + product.getProductName() + " za cenę " + product.getPrice());
				if(product.getDescription() != null) {
					System.out.println("Opis: " + product.getDescription());
				}
			} catch (RecordNotFound_Exception e) {
				System.out.println("Nie ma takiego rekordu");
			} catch (DBException_Exception e) {
				System.out.println("Inny błąd: " + e);
				e.printStackTrace();
			}
		}
	}

}
