package com.example.demo.wstrzykiwanie;

import jakarta.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Inject1 {
	// 1. sposób wstrzykiwania: pole
	@Autowired
	private Komponent komponent;

	@Autowired
	private Repo repo;
	
	{ System.out.println("Inject1 init"); } // initialization block
	
	public Inject1() {
		System.out.println("Inject1 constr, komponent = " + komponent); // null
	}
	
	@PostConstruct
	public void pc() {
		System.out.println("inject1 @PostConstruct, komponent = " + komponent);
	}
	
	@RequestMapping("/inject1")
	@ResponseBody
	public String get() {
		return repo.getText() + " " + komponent.getValue();
	}

}
