package com.example.demo.data;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.example.demo.model.Employee;

public interface Repository5 extends JpaRepository<Employee, Integer> {

	List<Employee> findByLastName(String name);

	List<Employee> findByLastNameContainingIgnoringCase(String name);
	
    List<Employee> findByJob_JobId(String jobId);

    // employee.getDepartment().getLocation().getCity()
    // ale w zapytaniu zostanie to zamienione na SQL, który JOIN-em dołącza tabele departments i locations i w WHERE sprawdza city
    List<Employee> findByDepartment_Location_City(String city);
    
    // Zapytanie w składni JPQL
    @Query("SELECT emp FROM Employee emp WHERE emp.salary BETWEEN :min AND :max ORDER BY emp.salary")
    List<Employee> findBySalary(BigDecimal min, BigDecimal max);
    
    @Query(nativeQuery=true,
            value="""
            		SELECT first_name || ' ' || last_name 
            		FROM employees
            		WHERE extract(year FROM hire_date) = :year
            		ORDER BY last_name
            	  """)
    List<String> namesByYear(int year);
    
    // W ramach takiego interfejsu można też pisać metody z własną implementacją.
    // Tu przykład już nie bazodanowy...
    default List<Integer> losowe(int limit, int ilosc) {
    	return ThreadLocalRandom.current().ints(ilosc, 0, limit).boxed().collect(Collectors.toList());
    }

    // podobno tak wygląda wywołanie procedury składowanej, ale nam nie działa
    @Query(nativeQuery=true, value="CALL przenies_pracownika(:idPracownika, :newDep, :newJob)")
	void moveEmployee(Integer idPracownika, int newDep, String newJob);
    
    @Query(nativeQuery=true, value="SELECT zarabiajacy_wiecej_niz(:id)")
    List<Employee> zarabiajacyWiecejNiz(int id);

    @Query(nativeQuery=true, value="SELECT nazwisko_szefa(:idPracownika)")
	String nazwiskoSzefa(Integer idPracownika);
}

