package com.example.demo.data;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.example.demo.model.Employee;

@Controller
@RequestMapping("/emps2")
public class Controller2 {
	@Autowired
	private Repository2 repository;
	
	@GetMapping
	public String showAll(Model model) {
		List<Employee> emps = repository.findAll();
		model.addAttribute("emps", emps);
		return "employees.html";
	}
	
	@GetMapping("/{id}")
	public String showOne(Model model,
			@PathVariable("id") Integer employeeId) {
		Employee emp = repository.findOne(employeeId);
		model.addAttribute("emps", List.of(emp));
		return "employees.html";
	}
    
    @GetMapping("/by_name")
    public String showByName(Model model,
            @RequestParam("name") String name) {
        List<Employee> emps = repository.findByLastName(name);
        model.addAttribute("emps", emps);
        return "employees.html";
    }	
}
