package sklep.przyklady_hibernate;

import java.util.List;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import sklep.model.Product;

public class OdczytajListe_NamedQuery {

	public static void main(String[] args) {
		try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
			EntityManager em = emf.createEntityManager()) {
			
			// Podajemy nazwę zapytania zdefiniowanego w ramach adnotacji @NamedQuery
			// Zgodnie z konwencją, każda klasa encji ma zdefiniowane zapytanie findAll:
			TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
			List<Product> products = query.getResultList();
			System.out.printf("Mam %d produktów:\n", products.size());
//			query.getFirstResult();
//			query.getSingleResult();
//			query.getResultStream();			
			
			for(Product product : products) {
				System.out.printf("%s za cenę %s\n", product.getProductName(), product.getPrice());
			}
		}
	}

}
