package com.example.demo;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("/kalkulator")
public class KalkulatorController {
	
	@GetMapping
	public String rozmowaGet() {
		return "kalkulator.html";
	}

	@PostMapping
	public String rozmowaPost(Long liczba1, Long liczba2, String operacja, Model model) {
		Long wynik = switch(operacja) {
			case "+"-> liczba1 + liczba2;
			case "-"-> liczba1 - liczba2;
			case "*"-> liczba1 * liczba2;
			case "/"-> liczba1 / liczba2;
			default -> 0L;
		};
		
		model.addAttribute("wynik", wynik);
		model.addAttribute("operacja", operacja);
		return "kalkulator.html";
	}
	
}
