package techniczne;

import java.io.IOException;
import java.io.PrintWriter;

import beans.ExampleBean;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;

@WebServlet("/Zakresy")
public class Zakresy extends HttpServlet {
    private static final long serialVersionUID = 1L;
    
    // Standard nie gwarantuje nam żadnego zachowania jeśli chodzi o zmienne instancyjne w serwletach.
    // Nie wiemy kiedy i ile obiektów klasy serwlet będzie tworzył serwer.
    // W praktyce zazwyczaj tworzony jest jeden wspólny obiekt dla wszystkich zapytań, ale nie możemy tego zakładać.
    private ExampleBean instancyjna = new ExampleBean();
    
    // Zmienna statyczna będzie istniała do restartu serwera albo redeploy aplikacji.
    private static ExampleBean statyczna = new ExampleBean();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    	ExampleBean lokalna = new ExampleBean();
        
        HttpSession sesja = request.getSession();
        
        ExampleBean req = (ExampleBean) request.getAttribute("licznik-req");
        ExampleBean ses = (ExampleBean) sesja.getAttribute("licznik-ses");
        ExampleBean app = (ExampleBean) getServletContext().getAttribute("licznik-app");
        
        
        response.setContentType("text/plain");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();

        out.println("lokalna    : " + lokalna.getLicznik());
        out.println("instancyjna: " + instancyjna.getLicznik());
        out.println("statyczna  : " + statyczna.getLicznik());
        out.println();
        out.println("request    : " + req.getLicznik());
        out.println("sesja      : " + ses.getLicznik());
        out.println("aplikacja  : " + app.getLicznik());
    }

}
