package podstawy;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/rozmowa")
public class Rozmowa extends HttpServlet {

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		out.println("<!DOCTYPE html>");
		out.println("<html><body>");
		out.println("<h1>Rozmowa z serwletem</h1>");
		// w Javie 17 pojawiły się wieloliniowe Stringi, jak w Pythonie:
		out.println("""
				<form>
					<label for="imie">Jak na imię?</label>
					<input id="imie" name="imie" type="text">
					<button>Wyślij</button>
				</form>
				""");
		
		// obsługa parametru
		
		String imie = request.getParameter("imie");
		out.println("<div>Witaj " + imie + "</div>");
		
		out.println("</body></html>");
	}
}
