package watki.na_zajeciach;

public class BBB_Join {
	
	static String info(Thread watek) {
		return "id: " + watek.getId() + " , nazwa: " + watek.getName();
	}

	public static void main(String[] args) {
		System.out.println("Początek maina");
		System.out.println("main: " + info(Thread.currentThread()));
		
		// klasa anonimowa
		Runnable trescA = new Runnable() {
			public void run() {
				System.out.println("Początek wątku A");
				System.out.println("AAA: " + info(Thread.currentThread()));
				for(int i = 1; i <= 100; i++) {
					System.out.println("AAA " + i);
				}
				System.out.println("Koniec wątku A");
			}
		};
		Thread watekA = new Thread(trescA);
		
		// wyrażenie lambda
		Thread watekB = new Thread(() -> {
			System.out.println("Początek wątku B");
			System.out.println("BBB: " + info(Thread.currentThread()));
			for(int i = 1; i <= 100; i++) {
				System.out.println("BBB " + i);
			}
			System.out.println("Koniec wątku B");
		});
		
		System.out.println("Przygotowane wątki:\n\t" + info(watekA) + "\n\t" + info(watekB));
		System.out.println("Uruchamiam wątki...\n");
		watekA.start();
		watekB.start();

		System.out.println(watekA.getState());
		System.out.println("main: czekam na zakończenie wątków");
		try {
			watekA.join();
			watekB.join();
			System.out.println("main: Wątki zakończone");
		} catch (InterruptedException e) {
			System.out.println("Interrupt! " + e);
		}
		
		System.out.println(watekA.getState());
		System.out.println("Koniec maina");
	}

}
