package sklep.model;

import java.time.LocalDateTime;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

/* W tej klasie definiujemy sposób tłumaczenie między jakimś typem, który JAXB potrafi obsługiwać (tutaj: String),
 * a typem używanym w naszej aplikacji (tutaj: LocalDateTime).
 */
public class AdapterDaty extends XmlAdapter<String, LocalDateTime> {
    @Override
    public LocalDateTime unmarshal(String s) {
        return LocalDateTime.parse(s);
    }

    @Override
    public String marshal(LocalDateTime dt) {
        return dt.toString();
    }

}
