package stare_przyklady;

import java.util.Arrays;
import java.util.List;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;

public class Odczyt08_Tablica {
	
	public static void main(String[] args) {
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			emf = Persistence.createEntityManagerFactory("hr_postgresql");
			em = emf.createEntityManager();
		
			TypedQuery<Object[]> query = em.createQuery("SELECT e.firstName, e.lastName, e.job.jobTitle, e.salary, e.department.departmentName, e.department.location.city FROM Employee e", Object[].class);
			List<Object[]> rows = query.getResultList();
			for (Object[] emp : rows) {
				System.out.println(Arrays.toString(emp));
			}
			
			System.out.println("\nSprawdzę typy kolumn:");
			Object[] row = (Object[])rows.get(0);
			System.out.println(row[0].getClass().getSimpleName() + " " + row[2].getClass().getSimpleName() + " " + row[3].getClass().getSimpleName());
		} finally {
			if(em != null)	em.close();
			if(emf != null)	emf.close();
		}
	}

}
