package com.example.demo.data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.example.demo.model.Employee;

@Controller
@RequestMapping("/emps5")
public class Controller5 {
	@Autowired
	private Repository5 repository;

	@GetMapping("/all")
	public String showAll(Model model) {
		List<Employee> emps = repository.findAll();
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	@GetMapping("/by_id/{id}")
	public String showOne(Model model, 
			@PathVariable("id") Integer employeeId) {

		Optional<Employee> emp = repository.findById(employeeId);
		List<Employee> emps;
		if (emp.isPresent()) {
			emps = List.of(emp.get());
		} else {
			emps = List.of();
		}
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	@GetMapping("/by_name")
	public String showByName(Model model,
			@RequestParam("name") String name) {
		List<Employee> emps = repository.findByLastName(name);
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	// http://localhost:8080/emps5/by_job/IT_PROG
	@GetMapping("/by_job/{job}")
	public String getEmployeesByJobId(Model model,
									  @PathVariable("job") String jobId) {

		List<Employee> emps = repository.findByJob_JobId(jobId);
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	// http://localhost:8080/emps5/by_city/Oxford
    @GetMapping("/by_city/{city}")
    public String getEmployeesByCity(Model model,
            @PathVariable("city") String city) {

		List<Employee> emps = repository.findByDepartment_Location_City(city);
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	// http://localhost:8080/emps5/by_salary?min=5000&max=10000
	@GetMapping("/by_salary")
	public String getEmployeesBySalary(Model model,
									   @RequestParam(name="min", defaultValue="0") BigDecimal min,
									   @RequestParam(name="max", defaultValue="1000000000") BigDecimal max) {

		List<Employee> employees = repository.findBySalary(min, max);
		model.addAttribute("emps", employees);
		return "employees.html";
	}

	@GetMapping("/by_year/{year}")
	public String getEmployeesByYear(Model model,
									 @PathVariable("year") int year) {

		List<String> names = repository.namesByYear(year);
		model.addAttribute("names", names);
		return "names.html";
	}
	
	@GetMapping("/zara")
	public String zarabiajacy(Model model,
			@RequestParam("id") int id) {
		List<Employee> emps = repository.zarabiajacyWiecejNiz(id);
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	@GetMapping("/szef/{id}")
	@ResponseBody
	public String szef(@PathVariable("id") Integer idPracownika) {
		return repository.nazwiskoSzefa(idPracownika);
	}
	
	@GetMapping("/save/{id}")
	public String modify(Model model,
						 @PathVariable("id") Integer idPracownika,
						 @RequestParam(value="salary", required=false) BigDecimal newSalary,
						 @RequestParam(value="first_name", required=false) String newFirstName,
						 @RequestParam(value="last_name", required=false) String newLastName) {
		Optional<Employee> found = repository.findById(idPracownika);
		List<Employee> emps;
		if(found.isPresent()) {
			Employee emp = found.get();
			if(newSalary != null)
				emp.setSalary(newSalary);
			if(newFirstName != null)
				emp.setFirstName(newFirstName);
			if(newLastName != null)
				emp.setLastName(newLastName);
			repository.save(emp);
			emps = List.of(emp);
		} else {
			emps = List.of();
		}
		model.addAttribute("emps", emps);
		return "employees.html";
	}
	
	@GetMapping("/move/{id}")
	@ResponseBody
	public String modify(Model model,
						 @PathVariable("id") Integer idPracownika,
						 @RequestParam(value="dep", required=false) int newDep,
						 @RequestParam(value="job", required=false) String newJob) {

		repository.moveEmployee(idPracownika, newDep, newJob);
		return "Przeniesiono";
	}
	
}
