package sklep.controller;

import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.time.LocalDateTime;

@Controller
public class RootController {
    @GetMapping("/")
    public String root() {
        return "index";
    }

    @GetMapping("/hello")
    @ResponseBody
    public String hello() {
        return "Hello! Aplikacja sklep";
    }

    @GetMapping("/time")
    public String currentTime(Model model) {
        LocalDateTime now = LocalDateTime.now();
        model.addAttribute("dt", now);
        return "show_time";
    }

    @GetMapping("/whoami")
    public String whoAmI(Authentication authentication, Model model) {
        if(authentication != null && authentication.isAuthenticated()) {
            model.addAttribute("userName", authentication.getName());
            model.addAttribute("authorities", authentication.getAuthorities());
        }
        return "whoami";
    }

}
