package com.example.demo.waluty;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/waluty.rest")
public class WalutyRest {
    @Autowired
    private PobieranieWalut pobieracz;
    
    @GetMapping
    public TabelaWalut wyswietlWaluty() {
        TabelaWalut tabela = pobieracz.pobierzBiezaceKursy();
        return tabela;
    }
    
    @GetMapping("/{data}")
    public TabelaWalut wyswietlWaluty(@PathVariable String data) {
        TabelaWalut tabela = pobieracz.pobierzArchiwalneKursy(data);
        return tabela;
    }

}
