package com.example.demo;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("/rozmowa")
public class RozmowaController {
    
    @GetMapping
    public String rozmowa() {
        // w przypadku metody GET tylko wyświetlamy pusty formularz
        return "rozmowa.html";
    }

    @PostMapping
    public String rozmowa(String imie, Model model) {
        // w przypadku metody POST pobieramy przysłane imię i umieszczamy powitanie na stronie
        // (o ile imię zostało przysłane)
        System.out.println("Przysłane imię: " + imie);
        if(imie != null && !imie.isEmpty()) {
            model.addAttribute("powitanie", "Witaj " + imie);
        }
        return "rozmowa.html";
    }
    
}
